/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.ws.api.uddi.WSUDDIUtils;
import java.util.Vector;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.DiscoveryURLs;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.business.Contacts;
import org.apache.juddi.datatype.service.BusinessServices;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VWUDDIBusinessEntity
implements Cloneable {
    private String m_uddiRegistryName = null;
    private boolean m_bPublish = false;
    private String m_publishUser = null;
    private BusinessEntity m_businessEntity = null;
    public static final String XML_TAG_VWBUSINESS_ENTITY = "VWBusinessEntity";
    public static final String XML_TAG_BUSINESS_ENTITY = "businessEntity";
    public static final String UDDI_TAG = "VWBusinessEntity";
    public static final String XML_ATTRIBUTE_PUBLISH = "publish";
    public static final String XML_ATTRIBUTE_PUBLISH_USER_NAME = "publishUserName";
    public static final String XML_ATTRIBUTE_UDDIREGISTRY = "uddiRegistry";

    public static String _get_FILE_DATE() {
        return "$Date:   25 Jan 2005 08:54:22  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dmcphee  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.8  $";
    }

    public VWUDDIBusinessEntity() {
        this.m_businessEntity = new BusinessEntity();
    }

    public VWUDDIBusinessEntity(String businessName, String uddiRegistry, boolean bPublish, String businessDescription, String businessKey, String userName) throws Exception {
        this.m_uddiRegistryName = uddiRegistry;
        this.m_businessEntity = new BusinessEntity();
        Vector<Object> v = new Vector<Object>();
        v.add(new Name(businessName.trim()));
        this.m_businessEntity.setNameVector(v);
        this.m_businessEntity.setBusinessKey(businessKey.trim());
        v = new Vector();
        v.add(new Description(businessDescription));
        this.m_businessEntity.setDescriptionVector(v);
        this.m_businessEntity.setAuthorizedName(userName);
        this.m_bPublish = bPublish;
    }

    public VWUDDIBusinessEntity(Element vwBusinessEle) throws Exception {
        this.m_uddiRegistryName = vwBusinessEle.getAttribute(XML_ATTRIBUTE_UDDIREGISTRY);
        String sPublish = vwBusinessEle.getAttribute(XML_ATTRIBUTE_PUBLISH);
        if (sPublish.compareTo("1") == 0) {
            this.m_bPublish = true;
        }
        this.m_publishUser = vwBusinessEle.getAttribute(XML_ATTRIBUTE_PUBLISH_USER_NAME);
        NodeList ndList = vwBusinessEle.getElementsByTagName(XML_TAG_BUSINESS_ENTITY);
        Element businessElem = (Element)ndList.item(0);
        this.m_businessEntity = WSUDDIUtils.createBusinessEntity(businessElem);
    }

    public BusinessEntity getBusinessEntity() {
        return this.m_businessEntity;
    }

    public void setBusinessEntity(BusinessEntity be) {
        this.m_businessEntity = be;
    }

    public String getUDDIRegistry() {
        return this.m_uddiRegistryName;
    }

    public void setUDDIRegistry(String uddiRegistry) {
        this.m_uddiRegistryName = uddiRegistry;
    }

    public boolean getPublish() {
        return this.m_bPublish;
    }

    public void setPublish(boolean bPublish) {
        this.m_bPublish = bPublish;
    }

    public String getAuthorizedName() {
        if (this.m_businessEntity != null) {
            return this.m_businessEntity.getAuthorizedName();
        }
        return null;
    }

    public void setAuthorizedName(String name) {
        this.m_businessEntity.setAuthorizedName(name);
    }

    public DiscoveryURLs getDiscoveryURLs() {
        return this.m_businessEntity.getDiscoveryURLs();
    }

    public VWUDDIBusinessEntity(String businessName, boolean bPublish, String businessDescription, String businessKey, String userName) throws Exception {
        this(businessName, null, bPublish, businessDescription, businessKey, userName);
    }

    public String getNameString(int index) {
        Vector nameList;
        String sName = null;
        if (this.m_businessEntity != null && (nameList = this.m_businessEntity.getNameVector()) != null && nameList.size() > index && nameList.elementAt(index) != null && nameList.elementAt(index) instanceof Name) {
            sName = ((Name)nameList.elementAt(index)).getValue();
        }
        return sName;
    }

    public void addName(Name name) {
        if (this.m_businessEntity != null) {
            this.m_businessEntity.addName(name);
        }
    }

    public String getDescriptionString(int i) {
        Vector v;
        if (this.m_businessEntity != null && (v = this.m_businessEntity.getDescriptionVector()) != null && v.size() > i && v.elementAt(i) != null && v.elementAt(i) instanceof Description) {
            return ((Description)v.elementAt(i)).getValue();
        }
        return null;
    }

    public Description getDescription(int i) {
        Vector v;
        if (this.m_businessEntity != null && (v = this.m_businessEntity.getDescriptionVector()) != null && v.size() > i && v.elementAt(i) != null && v.elementAt(i) instanceof Description) {
            return (Description)v.elementAt(i);
        }
        return null;
    }

    public Vector getDescriptionVector() {
        if (this.m_businessEntity != null) {
            return this.m_businessEntity.getDescriptionVector();
        }
        return null;
    }

    public void setDescriptionVector(Vector descriptionVector) {
        if (this.m_businessEntity != null) {
            this.m_businessEntity.setDescriptionVector(descriptionVector);
        }
    }

    public void addDescription(Description description) {
        if (this.m_businessEntity != null) {
            this.m_businessEntity.addDescription(description);
        }
    }

    public String getBusinessKey() {
        if (this.m_businessEntity != null) {
            return this.m_businessEntity.getBusinessKey();
        }
        return null;
    }

    public void setBusinessKey(String key) {
        if (this.m_businessEntity != null) {
            this.m_businessEntity.setBusinessKey(key);
        }
    }

    public BusinessServices getBusinessServices() {
        if (this.m_businessEntity != null) {
            return this.m_businessEntity.getBusinessServices();
        }
        return null;
    }

    public void setBusinessServices(BusinessServices s) {
        if (this.m_businessEntity != null) {
            this.m_businessEntity.setBusinessServices(s);
        }
    }

    public Contacts getContacts() {
        if (this.m_businessEntity != null) {
            return this.m_businessEntity.getContacts();
        }
        return null;
    }

    public void setContacts(Contacts s) {
        if (this.m_businessEntity != null) {
            this.m_businessEntity.setContacts(s);
        }
    }

    public Name getName(int index) {
        Vector v;
        if (this.m_businessEntity != null && (v = this.getNameVector()) != null && v.size() > index && v.elementAt(index) != null && v.elementAt(index) instanceof Name) {
            return (Name)v.elementAt(index);
        }
        return null;
    }

    public IdentifierBag getIdentifierBag() {
        if (this.m_businessEntity != null) {
            return this.m_businessEntity.getIdentifierBag();
        }
        return null;
    }

    public void setIdentifierBag(IdentifierBag s) {
        if (this.m_businessEntity != null) {
            this.m_businessEntity.setIdentifierBag(s);
        }
    }

    public Vector getNameVector() {
        if (this.m_businessEntity != null) {
            return this.m_businessEntity.getNameVector();
        }
        return null;
    }

    public void setNameVector(Vector s) {
        if (this.m_businessEntity != null) {
            this.m_businessEntity.setNameVector(s);
        }
    }

    public String getOperator() {
        if (this.m_businessEntity != null) {
            return this.m_businessEntity.getOperator();
        }
        return null;
    }

    public void setOperator(String operator) {
        if (this.m_businessEntity != null) {
            this.m_businessEntity.setOperator(operator);
        }
    }

    public String getPublishUserName() {
        return this.m_publishUser;
    }

    public void setPublishUserName(String name) {
        this.m_publishUser = name;
    }

    public void saveToXML(Element parent) {
        Element base = parent.getOwnerDocument().createElement("VWBusinessEntity");
        base.setAttribute(XML_ATTRIBUTE_PUBLISH, this.m_bPublish ? "1" : "0");
        if (this.m_publishUser != null) {
            base.setAttribute(XML_ATTRIBUTE_PUBLISH_USER_NAME, this.m_publishUser);
        }
        if (this.m_uddiRegistryName != null) {
            base.setAttribute(XML_ATTRIBUTE_UDDIREGISTRY, this.m_uddiRegistryName);
        }
        parent.appendChild(base);
        WSUDDIUtils.saveToXML(base, this.m_businessEntity);
    }

    public String toString() {
        return this.getNameString(0);
    }

    public void releaseResources() {
    }
}

